--[[
GreenBeanAndPeaHarvestAddon

Specialization to allow harvest green beans and peas with an harvester

Author: 	Ifko[nator]
Date: 		30.10.2025
Version:	1.1

History:	v1.0 @10.05.2025 - initial implemation in FS 25
            -----------------------------------------------
            v1.1 @30.10.2025 - fix for Patch 1.14.0.0
]]

GreenBeanAndPeaHarvestAddon = {}
GreenBeanAndPeaHarvestAddon.xmlSchema = {};

GreenBeanAndPeaHarvestAddon.currentModDirectory = g_currentModDirectory;

if GreenBeanAndPeaHarvestAddon.modDesc == nil then
    GreenBeanAndPeaHarvestAddon.modDesc = XMLFile.load("modDesc", Utils.getFilename("modDesc.xml", GreenBeanAndPeaHarvestAddon.currentModDirectory), GreenBeanAndPeaHarvestAddon.xmlSchema);
end;

if GreenBeanAndPeaHarvestAddon.modDesc ~= nil then
    GreenBeanAndPeaHarvestAddon.currentModName = g_currentModName;
    
    function GreenBeanAndPeaHarvestAddon:motionPathEffectManagerLoadMapData(xmlFile, missionInfo, baseDirectory)
        MotionPathEffectManager.createMotionPathEffectXMLSchema();

        g_motionPathEffectManager:loadMotionPathEffects(GreenBeanAndPeaHarvestAddon.modDesc.handle, "modDesc.motionPathEffects.motionPathEffect", GreenBeanAndPeaHarvestAddon.currentModDirectory, GreenBeanAndPeaHarvestAddon.currentModName);

        local motionPathEffectsXMLFilename = getXMLString(GreenBeanAndPeaHarvestAddon.modDesc.handle, "modDesc.motionPathEffects#filename");

        if motionPathEffectsXMLFilename ~= nil then
            local motionPathEffectsXMLFile = XMLFile.load("motionPathXML", Utils.getFilename(motionPathEffectsXMLFilename, GreenBeanAndPeaHarvestAddon.currentModDirectory), GreenBeanAndPeaHarvestAddon.xmlSchema);

            if motionPathEffectsXMLFile ~= nil then
                g_motionPathEffectManager:loadMotionPathEffects(motionPathEffectsXMLFile.handle, "motionPathEffects.motionPathEffect", GreenBeanAndPeaHarvestAddon.currentModDirectory, GreenBeanAndPeaHarvestAddon.currentModName);

                motionPathEffectsXMLFile:delete();
            end;
        end;

        return true;
    end;

    MotionPathEffectManager.loadMapData = Utils.prependedFunction(MotionPathEffectManager.loadMapData, GreenBeanAndPeaHarvestAddon.motionPathEffectManagerLoadMapData);

    function GreenBeanAndPeaHarvestAddon:fruitTypeManagerLoadMapData(superFunc, xmlFile, missionInfo, baseDirectory)
        superFunc(self, xmlFile, missionInfo, baseDirectory);

        local fruitTypesXMLFilename = getXMLString(GreenBeanAndPeaHarvestAddon.modDesc.handle, "modDesc.fruitTypes#filename");

        if fruitTypesXMLFilename ~= nil then
            local fruitTypesXMLFile = XMLFile.load("fruitTypes", Utils.getFilename(fruitTypesXMLFilename, GreenBeanAndPeaHarvestAddon.currentModDirectory), GreenBeanAndPeaHarvestAddon.xmlSchema);

            if fruitTypesXMLFile ~= nil then
                g_fruitTypeManager:loadFruitTypes(fruitTypesXMLFile.handle, missionInfo, false);

                fruitTypesXMLFile:delete();
            end;
        end;
    end;

    FruitTypeManager.loadMapData = Utils.overwrittenFunction(FruitTypeManager.loadMapData, GreenBeanAndPeaHarvestAddon.fruitTypeManagerLoadMapData);

    function GreenBeanAndPeaHarvestAddon:getValueType(superFunc, path)
        local schema = self.schema;

        if schema == nil then
            local foundGreenBeanAndPeaHarvestAddon = false;

            if type(self) == "number" then
                foundGreenBeanAndPeaHarvestAddon = getXMLFilename(self):find(GreenBeanAndPeaHarvestAddon.currentModName);
            elseif type(self) == "table" then
                foundGreenBeanAndPeaHarvestAddon = self:getFilename():find(GreenBeanAndPeaHarvestAddon.currentModName);
            elseif type(self) == "string" and (self.isa ~= nil and self:isa(XMLFile)) then
                foundGreenBeanAndPeaHarvestAddon = self:find(GreenBeanAndPeaHarvestAddon.currentModName);
            end;

            if not foundGreenBeanAndPeaHarvestAddon then
                Logging.xmlError(self, "Unable to get schema for xml file.");

                printCallstack();
            end;
            
            return;
        elseif path == nil then
            Logging.xmlError(self, "Unable to get value from unknown path.");

            printCallstack();

            return;
        else
            local separtorLocation = string.gsub(path, "%(%d*%)", "(?)");
            local separtor = schema.paths[separtorLocation];

            if separtor == nil then
                separtor = schema.paths[separtorLocation:gsub("%d+%.", "%?%."):gsub("%d+#", "%?#"):gsub("%d+$", "%?")]
            end;

            if separtor ~= nil then
                return XMLValueType.TYPES[separtor.valueTypeId]
            end;

            Logging.xmlError(self, "Failed to validate xml path \'%s\' for schema \'%s\'. Path not registered.", path, schema.name);

            printCallstack();
        end;
    end;

    XMLFile.getValueType = Utils.overwrittenFunction(XMLFile.getValueType, GreenBeanAndPeaHarvestAddon.getValueType);
end;